/*
 * Decompiled with CFR 0.152.
 */
package net.adventurez.entity.goal;

import java.util.EnumSet;
import net.adventurez.entity.DragonEntity;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;

public class DragonFindOwnerGoal
extends Goal {
    private final DragonEntity dragonEntity;
    private LivingEntity owner;
    private final double speed;
    private final PathNavigation navigation;
    private int updateCountdownTicks;
    private final float maxDistance;
    private final float minDistance;
    private float oldWaterPathfindingPenalty;

    public DragonFindOwnerGoal(DragonEntity dragonEntity, double speed, float minDistance, float maxDistance) {
        this.dragonEntity = dragonEntity;
        this.speed = speed;
        this.navigation = dragonEntity.m_21573_();
        this.minDistance = minDistance;
        this.maxDistance = maxDistance;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        LivingEntity livingEntity = this.dragonEntity.m_269323_();
        if (livingEntity == null) {
            return false;
        }
        if (livingEntity.m_5833_()) {
            return false;
        }
        if (this.dragonEntity.isInSittingPose()) {
            return false;
        }
        if (!this.dragonEntity.isFlying) {
            return false;
        }
        if (this.dragonEntity.m_20160_()) {
            return false;
        }
        if (!this.dragonEntity.m_142582_((Entity)livingEntity)) {
            return false;
        }
        if (this.dragonEntity.m_20280_((Entity)livingEntity) < (double)(this.minDistance * this.minDistance)) {
            return false;
        }
        this.owner = livingEntity;
        return true;
    }

    public boolean m_8045_() {
        if (this.dragonEntity.m_20280_((Entity)this.owner) > 800.0) {
            return false;
        }
        if (this.dragonEntity.isInSittingPose() || !this.dragonEntity.m_142582_((Entity)this.owner)) {
            return false;
        }
        return this.dragonEntity.m_20280_((Entity)this.owner) > (double)(this.maxDistance * this.maxDistance) && !this.dragonEntity.m_20096_() && this.dragonEntity.isFlying;
    }

    public void m_8056_() {
        this.updateCountdownTicks = 0;
        this.oldWaterPathfindingPenalty = this.dragonEntity.m_21439_(BlockPathTypes.WATER);
        this.dragonEntity.m_21441_(BlockPathTypes.WATER, 0.0f);
    }

    public void m_8041_() {
        this.owner = null;
        this.navigation.m_26573_();
        this.dragonEntity.m_21441_(BlockPathTypes.WATER, this.oldWaterPathfindingPenalty);
    }

    public void m_8037_() {
        this.dragonEntity.m_21563_().m_24960_((Entity)this.owner, 10.0f, (float)this.dragonEntity.m_8132_());
        if (--this.updateCountdownTicks <= 0) {
            this.updateCountdownTicks = 10;
            if (!this.dragonEntity.m_21523_() && !this.dragonEntity.m_20159_() && this.dragonEntity.m_20280_((Entity)this.owner) <= 800.0) {
                Vec3 vec3d = new Vec3(this.owner.m_20185_() - this.dragonEntity.m_20185_(), this.owner.m_20186_() - this.dragonEntity.m_20186_(), this.owner.m_20189_() - this.dragonEntity.m_20189_());
                vec3d = vec3d.m_82541_();
                this.dragonEntity.m_20256_(this.dragonEntity.m_20184_().m_82549_(vec3d.m_82490_(this.speed)));
            }
        }
    }
}

